##固定效应OLS面板VAR代码

#1.关键包
library(panelvar)

#2.读取数据，本案例数据有stata整理之后导入
pdata<-read.csv("D:\\硕士工作\\气候金融\\工作一 大宗商品与气候感知\\方法及参考文献\\R语言实现\\PVAR FEOLS\\data.csv",header=T)
pdata=na.omit(pdata)

#3.初步FEOLS回归
#dlnp=pvarfeols(dependent_vars=c("dlnprice","dgsvi"),lags=lags[1],data=pdata,panel_identifier=c("newid","newtime"))
#vola=pvarfeols(dependent_vars=c("vol","dgsvi"),lags=lags[2],data=pdata,panel_identifier=c("newid","newtime"))
#dunc=pvarfeols(dependent_vars=c("dunc","dgsvi"),lags=lags[3],data=pdata,panel_identifier=c("newid","newtime"))

#4.初始化信息- 变量信息；大宗商品名称
vars<-c("dlnprice","vol","dunc")
ari<-c("Cocoa","Coffee","Corn","Cotton","Oats","Orange juice","Soybean meals","Soybeans","Sugar","Wheat")
ene<-c("Gasoline","Heating oil","WTI oil")
liv<-c("Feeder cattle","Lean hog","Live cattle")
met<-c("Aluminium","Copper","Gold","Nickel","Palladium","Platinum","Silver")
all<-c("Cocoa","Coffee","Corn","Cotton","Oats","Orange juice","Soybean meals","Soybeans","Sugar","Wheat",
       "Gasoline","Heating oil","WTI oil",
       "Feeder cattle","Lean hog","Live cattle",
       "Aluminium","Copper","Gold","Nickel","Palladium","Platinum","Silver")

#手动指定滞后长度，也可以借助连玉君面板VAR方法计算滞后长度
lags<-c(1,1,1)
#5.绘图上下5%error band
for (i in 1:3){
  PlotORIF(lags[i],vars[i],met)
}


#bootstrap 代码
#lag滞后，var变量名,commodity大宗商品列表
PlotORIF<-function(lag,var,commodity){
  #迭代次数
  ite=100
  #step步数
  nhead=9
  
  #样本尺寸，并基于此进行抽样
  size=length(commodity)
  
  oirfs<-c()
  for(it in 1:ite){
    newids=ceiling(runif(size*2,0,size))
    
    newpdata<-pdata[which(pdata$newid==commodity[newids[1]]),]
    newpdata$newid=1
    
    for(i in 2:length(newids)){
      data<-pdata[which(pdata$newid==commodity[newids[i]]),]
      data$newid=i
      newpdata<-rbind(newpdata,data)
    }
    oirfs<-append(oirfs,oirf(pvarfeols(dependent_vars=c("dgsvi",var),lags=lag,data=newpdata,panel_identifier=c("newid","newtime")),n.ahead = nhead)$dgsvi[,2])
  }
  
  oirf_mat<-matrix(oirfs,nrow=nhead)
  means<-c()
  low<-c()
  high<-c()
  for(i in 1:nrow(oirf_mat)){
    means<-append(means,mean(oirf_mat[i,]))
    low<-append(low,quantile(oirf_mat[i,],probs=0.05))
    high<-append(high,quantile(oirf_mat[i,],probs=0.95))
  }
  print(means)
  print(low)
  print(high)
  #plot(high,type="l",ylim=c(min(low),max(high)),ann=,col=2,xlab="",lwd=1.5,ylab="",cex.axis=1.5,cex.lab=2,cex.main=3)
  #lines(low,type="l",col=2,lwd=1.5)
  #lines(means,type="l",lwd=3)
  #lines(rep(0,10),type="l")
}
